<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Category::withCount('products')->get();
        return view('categories.index', compact('categories'));
    }

    public function show(Category $category, Request $request)
    {
        $query = $category->products()->with(['user', 'category'])->active();

        if ($request->has('search') && $request->search) {
            $query->search($request->search);
        }

        $products = $query->latest()->paginate(12);
        $categories = Category::all();

        return view('categories.show', compact('category', 'products', 'categories'));
    }
}
