<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            ['name' => 'Electronics', 'description' => 'Phones, laptops, gadgets, and electronics'],
            ['name' => 'Books', 'description' => 'Textbooks, novels, and educational materials'],
            ['name' => 'Furniture', 'description' => 'Chairs, desks, beds, and home furniture'],
            ['name' => 'Clothing', 'description' => 'Clothes, shoes, and accessories'],
            ['name' => 'Sports', 'description' => 'Sports equipment and fitness gear'],
            ['name' => 'Transportation', 'description' => 'Bicycles, scooters, and transport items'],
            ['name' => 'Stationery', 'description' => 'Notebooks, pens, and office supplies'],
            ['name' => 'Food & Drinks', 'description' => 'Food items and beverages'],
            ['name' => 'Services', 'description' => 'Tutoring, repairs, and other services'],
            ['name' => 'Other', 'description' => 'Miscellaneous items'],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }
    }
}
