@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <h1 class="text-3xl font-bold mb-8">Admin Dashboard</h1>

    <!-- Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="text-2xl font-bold text-yellow-400">{{ $stats['total_users'] }}</div>
            <div class="text-gray-500">Total Users</div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="text-2xl font-bold text-yellow-400">{{ $stats['total_products'] }}</div>
            <div class="text-gray-500">Total Products</div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="text-2xl font-bold text-yellow-400">{{ $stats['active_products'] }}</div>
            <div class="text-gray-500">Active Listings</div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="text-2xl font-bold text-yellow-400">{{ $stats['total_messages'] }}</div>
            <div class="text-gray-500">Total Messages</div>
        </div>
    </div>

    <!-- Recent Products -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-8">
        <h2 class="text-xl font-bold mb-4">Recent Products</h2>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b">
                        <th class="text-left py-3 px-4">Title</th>
                        <th class="text-left py-3 px-4">Seller</th>
                        <th class="text-left py-3 px-4">Price</th>
                        <th class="text-left py-3 px-4">Status</th>
                        <th class="text-left py-3 px-4">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($recentProducts as $product)
                        <tr class="border-b">
                            <td class="py-3 px-4">{{ $product->title }}</td>
                            <td class="py-3 px-4">{{ $product->user->name }}</td>
                            <td class="py-3 px-4">${{ number_format($product->price, 2) }}</td>
                            <td class="py-3 px-4">
                                @if($product->status === 'sold')
                                    <span class="text-red-500">Sold</span>
                                @else
                                    <span class="text-green-500">Active</span>
                                @endif
                            </td>
                            <td class="py-3 px-4">
                                <a href="{{ route('products.show', $product) }}" class="text-blue-500 hover:underline mr-2">View</a>
                                <form action="{{ route('admin.products.destroy', $product) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-500 hover:underline" onclick="return confirm('Are you sure?')">
                                        Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- Users List -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="text-xl font-bold mb-4">All Users</h2>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b">
                        <th class="text-left py-3 px-4">Name</th>
                        <th class="text-left py-3 px-4">Email</th>
                        <th class="text-left py-3 px-4">Campus</th>
                        <th class="text-left py-3 px-4">Products</th>
                        <th class="text-left py-3 px-4">Joined</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                        <tr class="border-b">
                            <td class="py-3 px-4">{{ $user->name }}</td>
                            <td class="py-3 px-4">{{ $user->email }}</td>
                            <td class="py-3 px-4">{{ $user->campus ?: 'N/A' }}</td>
                            <td class="py-3 px-4">{{ $user->products_count }}</td>
                            <td class="py-3 px-4">{{ $user->created_at->format('M d, Y') }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
