@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <h1 class="text-3xl font-bold mb-8">Messages</h1>

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="grid grid-cols-1 md:grid-cols-3 h-[600px]">
            <!-- Conversation List -->
            <div class="border-r border-gray-200 overflow-y-auto">
                @if($conversations->isEmpty())
                    <div class="p-6 text-center text-gray-500">
                        <p>No messages yet</p>
                    </div>
                @else
                    @foreach($conversations as $conversation)
                        <a href="{{ route('messages.show', $conversation['user']->id) }}" 
                           class="block p-4 hover:bg-gray-50 border-b border-gray-100 {{ isset($selectedUser) && $selectedUser->id == $conversation['user']->id ? 'bg-gray-100' : '' }}">
                            <div class="flex items-center gap-3">
                                @if($conversation['user']->avatar)
                                    <img src="{{ Storage::url($conversation['user']->avatar) }}" alt="{{ $conversation['user']->name }}" class="w-12 h-12 rounded-full object-cover">
                                @else
                                    <div class="w-12 h-12 rounded-full bg-yellow-400 flex items-center justify-center text-black font-bold">
                                        {{ substr($conversation['user']->name, 0, 1) }}
                                    </div>
                                @endif
                                <div class="flex-1 min-w-0">
                                    <div class="flex justify-between items-center">
                                        <h3 class="font-semibold truncate">{{ $conversation['user']->name }}</h3>
                                        <span class="text-xs text-gray-500">{{ $conversation['last_message_time'] }}</span>
                                    </div>
                                    <p class="text-sm text-gray-500 truncate">
                                        {{ $conversation['last_message'] }}
                                    </p>
                                    @if($conversation['unread_count'] > 0)
                                        <span class="inline-block bg-yellow-400 text-black text-xs px-2 py-1 rounded-full mt-1">
                                            {{ $conversation['unread_count'] }} new
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </a>
                    @endforeach
                @endif
            </div>

            <!-- Chat Window -->
            <div class="col-span-2 flex flex-col">
                @if(isset($selectedUser))
                    <!-- Chat Header -->
                    <div class="p-4 border-b border-gray-200 bg-gray-50">
                        <div class="flex items-center gap-3">
                            @if($selectedUser->avatar)
                                <img src="{{ Storage::url($selectedUser->avatar) }}" alt="{{ $selectedUser->name }}" class="w-10 h-10 rounded-full object-cover">
                            @else
                                <div class="w-10 h-10 rounded-full bg-yellow-400 flex items-center justify-center text-black font-bold">
                                    {{ substr($selectedUser->name, 0, 1) }}
                                </div>
                            @endif
                            <div>
                                <h3 class="font-semibold">{{ $selectedUser->name }}</h3>
                                @if(isset($selectedProduct))
                                    <p class="text-sm text-gray-500">Re: {{ $selectedProduct->title }}</p>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Messages -->
                    <div class="flex-1 overflow-y-auto p-4 space-y-4" id="chat-messages">
                        @foreach($messages as $message)
                            <div class="flex {{ $message->sender_id === Auth::id() ? 'justify-end' : 'justify-start' }}">
                                <div class="max-w-[70%] {{ $message->sender_id === Auth::id() ? 'bg-yellow-400 text-black' : 'bg-gray-200 text-gray-800' }} px-4 py-2 rounded-lg">
                                    <p>{{ $message->message }}</p>
                                    <p class="text-xs mt-1 opacity-70">{{ $message->created_at->format('g:i A') }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Message Form -->
                    <form action="{{ route('messages.store') }}" method="POST" class="p-4 border-t border-gray-200">
                        @csrf
                        <input type="hidden" name="receiver_id" value="{{ $selectedUser->id }}">
                        @if(isset($selectedProduct))
                            <input type="hidden" name="product_id" value="{{ $selectedProduct->id }}">
                        @endif
                        <div class="flex gap-2">
                            <input type="text" name="message" placeholder="Type a message..." required
                                   class="flex-1 px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
                            <button type="submit" class="bg-yellow-400 text-black px-6 py-2 rounded-lg hover:bg-yellow-300">
                                Send
                            </button>
                        </div>
                    </form>
                @else
                    <div class="flex-1 flex items-center justify-center text-gray-500">
                        <div class="text-center">
                            <p class="text-xl mb-2">💬</p>
                            <p>Select a conversation to start messaging</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
