@extends('layouts.app')

@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <h1 class="text-3xl font-bold mb-8">Edit Item</h1>

    <form action="{{ route('products.update', $product) }}" method="POST" enctype="multipart/form-data" class="bg-white rounded-lg shadow-md p-6">
        @csrf
        @method('PUT')

        <div class="mb-6">
            <label for="title" class="block text-sm font-medium text-gray-700 mb-2">Title *</label>
            <input type="text" name="title" id="title" value="{{ old('title', $product->title) }}" required
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
            @error('title')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="mb-6">
            <label for="category_id" class="block text-sm font-medium text-gray-700 mb-2">Category *</label>
            <select name="category_id" id="category_id" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
                <option value="">Select a category</option>
                @foreach($categories as $category)
                    <option value="{{ $category->id }}" {{ old('category_id', $product->category_id) == $category->id ? 'selected' : '' }}>
                        {{ $category->name }}
                    </option>
                @endforeach
            </select>
            @error('category_id')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <div>
                <label for="price" class="block text-sm font-medium text-gray-700 mb-2">Price ($) *</label>
                <input type="number" name="price" id="price" value="{{ old('price', $product->price) }}" step="0.01" min="0" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
                @error('price')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
            <div>
                <label for="location" class="block text-sm font-medium text-gray-700 mb-2">Location/Campus *</label>
                <input type="text" name="location" id="location" value="{{ old('location', $product->location) }}" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
                @error('location')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
        </div>

        <div class="mb-6">
            <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description *</label>
            <textarea name="description" id="description" rows="5" required
                      class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">{{ old('description', $product->description) }}</textarea>
            @error('description')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="mb-6">
            <label for="images" class="block text-sm font-medium text-gray-700 mb-2">Add New Images (max 5)</label>
            <input type="file" name="images[]" id="images" multiple accept="image/*"
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
            <p class="text-sm text-gray-500 mt-1">You can select multiple images (JPEG, PNG, JPG, GIF)</p>
            @error('images')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        @if($product->images && count($product->images) > 0)
            <div class="mb-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Current Images</label>
                <div class="grid grid-cols-3 gap-4">
                    @foreach($product->images as $index => $image)
                        <div class="relative">
                            <img src="{{ Storage::url($image) }}" alt="Product image" class="w-full h-24 object-cover rounded-lg">
                            <a href="{{ route('products.remove-image', ['product' => $product->id, 'index' => $index]) }}" 
                               class="absolute top-0 right-0 bg-red-500 text-white rounded-full p-1 text-xs">
                                ✕
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        <div class="flex gap-4">
            <button type="submit" class="flex-1 bg-yellow-400 text-black py-3 rounded-lg font-semibold hover:bg-yellow-300">
                Update Item
            </button>
            <a href="{{ route('products.show', $product) }}" class="bg-gray-200 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-300">
                Cancel
            </a>
        </div>
    </form>
</div>
@endsection
