@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <a href="{{ route('products.index') }}" class="text-gray-600 hover:text-black mb-4 inline-block">← Back to listings</a>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        <!-- Image Gallery -->
        <div>
            @if($product->images && count($product->images) > 0)
                <div class="main-image mb-4">
                    <img src="{{ Storage::url($product->images[0]) }}" alt="{{ $product->title }}" class="w-full h-96 object-cover rounded-lg">
                </div>
                @if(count($product->images) > 1)
                    <div class="thumbnail-grid grid grid-cols-4 gap-2">
                        @foreach($product->images as $image)
                            <img src="{{ Storage::url($image) }}" alt="{{ $product->title }}" 
                                 class="w-full h-20 object-cover rounded-lg cursor-pointer hover:opacity-80">
                        @endforeach
                    </div>
                @endif
            @else
                <div class="w-full h-96 bg-gray-200 rounded-lg flex items-center justify-center">
                    <span class="text-6xl">📦</span>
                </div>
            @endif
        </div>

        <!-- Product Details -->
        <div>
            @if($product->status === 'sold')
                <div class="bg-red-100 text-red-600 px-4 py-2 rounded-lg mb-4">
                    This item has been sold
                </div>
            @endif
            
            <h1 class="text-3xl font-bold mb-2">{{ $product->title }}</h1>
            <p class="text-3xl font-bold text-yellow-400 mb-4">${{ number_format($product->price, 2) }}</p>
            
            <div class="flex items-center gap-4 mb-6 text-gray-600">
                <span>📍 {{ $product->location }}</span>
                <span>📁 {{ $product->category->name }}</span>
            </div>

            <div class="mb-6">
                <h2 class="text-lg font-semibold mb-2">Description</h2>
                <p class="text-gray-600">{{ $product->description }}</p>
            </div>

            <!-- Seller Info -->
            <div class="bg-gray-50 p-4 rounded-lg mb-6">
                <h3 class="text-lg font-semibold mb-2">Seller Information</h3>
                <div class="flex items-center gap-3">
                    @if($product->user->avatar)
                        <img src="{{ Storage::url($product->user->avatar) }}" alt="{{ $product->user->name }}" class="w-12 h-12 rounded-full object-cover">
                    @else
                        <div class="w-12 h-12 rounded-full bg-yellow-400 flex items-center justify-center text-black font-bold">
                            {{ substr($product->user->name, 0, 1) }}
                        </div>
                    @endif
                    <div>
                        <p class="font-semibold">{{ $product->user->name }}</p>
                        <p class="text-sm text-gray-500">{{ $product->user->campus }}</p>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="flex gap-4">
                @auth
                    @if($product->user_id !== Auth::user()->id && $product->status !== 'sold')
                        <a href="{{ route('messages.create', ['product' => $product->id, 'user' => $product->user->id]) }}" 
                           class="flex-1 bg-yellow-400 text-black text-center py-3 rounded-lg font-semibold hover:bg-yellow-300">
                            Message Seller
                        </a>
                    @endif

                    @if($product->user_id === Auth::user()->id || Auth::user()->is_admin)
                        <a href="{{ route('products.edit', $product) }}" class="bg-gray-200 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-300">
                            Edit
                        </a>
                        <form action="{{ route('products.destroy', $product) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="bg-red-500 text-white px-6 py-3 rounded-lg hover:bg-red-600" 
                                    onclick="return confirm('Are you sure you want to delete this product?')">
                                Delete
                            </button>
                        </form>
                    @endif

                    @if($product->user_id === Auth::user()->id && $product->status !== 'sold')
                        <form action="{{ route('products.mark-sold', $product) }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="bg-green-500 text-white px-6 py-3 rounded-lg hover:bg-green-600">
                                Mark as Sold
                            </button>
                        </form>
                    @endif
                @else
                    <a href="{{ route('login') }}" class="flex-1 bg-yellow-400 text-black text-center py-3 rounded-lg font-semibold hover:bg-yellow-300">
                        Login to Message
                    </a>
                @endauth
            </div>
        </div>
    </div>
</div>
@endsection
