@extends('layouts.app')

@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <h1 class="text-3xl font-bold mb-8">Edit Profile</h1>

    <form action="{{ route('profile.update') }}" method="POST" enctype="multipart/form-data" class="bg-white rounded-lg shadow-md p-6">
        @csrf
        @method('PUT')

        <div class="mb-6">
            <label for="avatar" class="block text-sm font-medium text-gray-700 mb-2">Profile Picture</label>
            <div class="flex items-center gap-4">
                @if($user->avatar)
                    <img src="{{ Storage::url($user->avatar) }}" alt="{{ $user->name }}" class="w-20 h-20 rounded-full object-cover">
                @else
                    <div class="w-20 h-20 rounded-full bg-yellow-400 flex items-center justify-center text-2xl text-black font-bold">
                        {{ substr($user->name, 0, 1) }}
                    </div>
                @endif
                <input type="file" name="avatar" id="avatar" accept="image/*"
                       class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
            </div>
        </div>

        <div class="mb-6">
            <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Name *</label>
            <input type="text" name="name" id="name" value="{{ old('name', $user->name) }}" required
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
            @error('name')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="mb-6">
            <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email *</label>
            <input type="email" name="email" id="email" value="{{ old('email', $user->email) }}" required
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
            @error('email')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="mb-6">
            <label for="campus" class="block text-sm font-medium text-gray-700 mb-2">Campus</label>
            <input type="text" name="campus" id="campus" value="{{ old('campus', $user->campus) }}"
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
            @error('campus')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="mb-6">
            <label for="department" class="block text-sm font-medium text-gray-700 mb-2">Department</label>
            <input type="text" name="department" id="department" value="{{ old('department', $user->department) }}"
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
            @error('department')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="mb-6">
            <label for="level" class="block text-sm font-medium text-gray-700 mb-2">Level (e.g., Freshman, Sophomore)</label>
            <input type="text" name="level" id="level" value="{{ old('level', $user->level) }}"
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
            @error('level')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div class="flex gap-4">
            <button type="submit" class="flex-1 bg-yellow-400 text-black py-3 rounded-lg font-semibold hover:bg-yellow-300">
                Update Profile
            </button>
            <a href="{{ route('profile.show') }}" class="bg-gray-200 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-300">
                Cancel
            </a>
        </div>
    </form>
</div>
@endsection
