@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
        <!-- Profile Sidebar -->
        <div class="md:col-span-1">
            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="text-center">
                    @if($user->avatar)
                        <img src="{{ Storage::url($user->avatar) }}" alt="{{ $user->name }}" class="w-32 h-32 rounded-full mx-auto object-cover">
                    @else
                        <div class="w-32 h-32 rounded-full bg-yellow-400 flex items-center justify-center text-4xl text-black font-bold mx-auto">
                            {{ substr($user->name, 0, 1) }}
                        </div>
                    @endif
                    <h2 class="text-2xl font-bold mt-4">{{ $user->name }}</h2>
                    <p class="text-gray-500">{{ $user->email }}</p>
                </div>
                
                <div class="mt-6 space-y-3">
                    <div class="flex justify-between border-b pb-2">
                        <span class="text-gray-500">Campus</span>
                        <span class="font-medium">{{ $user->campus ?: 'Not set' }}</span>
                    </div>
                    <div class="flex justify-between border-b pb-2">
                        <span class="text-gray-500">Department</span>
                        <span class="font-medium">{{ $user->department ?: 'Not set' }}</span>
                    </div>
                    <div class="flex justify-between border-b pb-2">
                        <span class="text-gray-500">Level</span>
                        <span class="font-medium">{{ $user->level ?: 'Not set' }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Member since</span>
                        <span class="font-medium">{{ $user->created_at->format('M Y') }}</span>
                    </div>
                </div>

                @if(Auth::id() === $user->id)
                    <a href="{{ route('profile.edit') }}" class="block w-full bg-black text-white text-center py-2 rounded-lg mt-6 hover:bg-gray-800">
                        Edit Profile
                    </a>
                @endif
            </div>
        </div>

        <!-- Profile Content -->
        <div class="md:col-span-2">
            <!-- My Listings -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-xl font-bold">My Listings</h3>
                    <a href="{{ route('products.create') }}" class="bg-yellow-400 text-black px-4 py-2 rounded-lg hover:bg-yellow-300">
                        Add New
                    </a>
                </div>
                
                @if($products->isEmpty())
                    <p class="text-gray-500 text-center py-4">You haven't posted any items yet.</p>
                @else
                    <div class="space-y-4">
                        @foreach($products as $product)
                            <div class="flex items-center gap-4 p-4 border rounded-lg">
                                @if($product->images && count($product->images) > 0)
                                    <img src="{{ Storage::url($product->images[0]) }}" alt="{{ $product->title }}" class="w-20 h-20 object-cover rounded-lg">
                                @else
                                    <div class="w-20 h-20 bg-gray-200 rounded-lg flex items-center justify-center">
                                        <span class="text-2xl">📦</span>
                                    </div>
                                @endif
                                <div class="flex-1">
                                    <h4 class="font-semibold">{{ $product->title }}</h4>
                                    <p class="text-yellow-400 font-bold">${{ number_format($product->price, 2) }}</p>
                                    <p class="text-sm text-gray-500">
                                        @if($product->status === 'sold')
                                            <span class="text-red-500">Sold</span>
                                        @else
                                            <span class="text-green-500">Active</span>
                                        @endif
                                    </p>
                                </div>
                                <div class="flex gap-2">
                                    <a href="{{ route('products.edit', $product) }}" class="text-gray-500 hover:text-black">
                                        Edit
                                    </a>
                                    <form action="{{ route('products.destroy', $product) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-500 hover:text-red-700" onclick="return confirm('Are you sure?')">
                                            Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            <!-- Recent Messages Preview -->
            @if(Auth::id() === $user->id)
            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-xl font-bold">Recent Messages</h3>
                    <a href="{{ route('messages.index') }}" class="text-yellow-400 hover:text-yellow-300">View All</a>
                </div>
                
                @if($recentMessages->isEmpty())
                    <p class="text-gray-500 text-center py-4">No messages yet.</p>
                @else
                    <div class="space-y-3">
                        @foreach($recentMessages as $message)
                            <a href="{{ route('messages.show', $message->sender_id === Auth::id() ? $message->receiver_id : $message->sender_id) }}" 
                               class="block p-3 border rounded-lg hover:bg-gray-50">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-full bg-yellow-400 flex items-center justify-center text-black font-bold">
                                        {{ substr($message->sender->name, 0, 1) }}
                                    </div>
                                    <div class="flex-1">
                                        <p class="font-semibold">{{ $message->sender_id === Auth::id() ? $message->receiver->name : $message->sender->name }}</p>
                                        <p class="text-sm text-gray-500 truncate">{{ $message->message }}</p>
                                    </div>
                                    <span class="text-xs text-gray-400">{{ $message->created_at->diffForHumans() }}</span>
                                </div>
                            </a>
                        @endforeach
                    </div>
                @endif
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
